// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentityUserFlowAttributeDataType;
import com.microsoft.graph.models.IdentityUserFlowAttributeType;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity User Flow Attribute.
 */
public class IdentityUserFlowAttribute extends Entity implements IJsonBackedObject {


    /**
     * The Data Type.
     * The data type of the user flow attribute. This can't be modified after the custom user flow attribute is created. The supported values for dataType are: string , boolean , int64 , stringCollection , dateTime, unknownFutureValue.  Supports $filter (eq, ne).
     */
    @SerializedName(value = "dataType", alternate = {"DataType"})
    @Expose
	@Nullable
    public IdentityUserFlowAttributeDataType dataType;

    /**
     * The Description.
     * The description of the user flow attribute that's shown to the user at the time of sign-up.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The display name of the user flow attribute.  Supports $filter (eq, ne).
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The User Flow Attribute Type.
     * The type of the user flow attribute. This is a read-only attribute that is automatically set. Depending on the type of attribute, the values for this property are builtIn, custom, required, unknownFutureValue.  Supports $filter (eq, ne).
     */
    @SerializedName(value = "userFlowAttributeType", alternate = {"UserFlowAttributeType"})
    @Expose
	@Nullable
    public IdentityUserFlowAttributeType userFlowAttributeType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
