// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.StagedFeatureName;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.DirectoryObjectCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Feature Rollout Policy.
 */
public class FeatureRolloutPolicy extends Entity implements IJsonBackedObject {


    /**
     * The Description.
     * A description for this feature rollout policy.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The display name for this  feature rollout policy.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Feature.
     * Possible values are: passthroughAuthentication, seamlessSso, passwordHashSync, emailAsAlternateId, unknownFutureValue.
     */
    @SerializedName(value = "feature", alternate = {"Feature"})
    @Expose
	@Nullable
    public StagedFeatureName feature;

    /**
     * The Is Applied To Organization.
     * Indicates whether this feature rollout policy should be applied to the entire organization.
     */
    @SerializedName(value = "isAppliedToOrganization", alternate = {"IsAppliedToOrganization"})
    @Expose
	@Nullable
    public Boolean isAppliedToOrganization;

    /**
     * The Is Enabled.
     * Indicates whether the feature rollout is enabled.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Applies To.
     * Nullable. Specifies a list of directoryObjects that feature is enabled for.
     */
    @SerializedName(value = "appliesTo", alternate = {"AppliesTo"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DirectoryObjectCollectionPage appliesTo;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("appliesTo")) {
            appliesTo = serializer.deserializeObject(json.get("appliesTo"), com.microsoft.graph.requests.DirectoryObjectCollectionPage.class);
        }
    }
}
