// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audit Event Get Audit Activity Types Parameter Set.
 */
public class AuditEventGetAuditActivityTypesParameterSet {
    /**
     * The category.
     * 
     */
    @SerializedName(value = "category", alternate = {"Category"})
    @Expose
	@Nullable
    public String category;


    /**
     * Instiaciates a new AuditEventGetAuditActivityTypesParameterSet
     */
    public AuditEventGetAuditActivityTypesParameterSet() {}
    /**
     * Instiaciates a new AuditEventGetAuditActivityTypesParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected AuditEventGetAuditActivityTypesParameterSet(@Nonnull final AuditEventGetAuditActivityTypesParameterSetBuilder builder) {
        this.category = builder.category;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static AuditEventGetAuditActivityTypesParameterSetBuilder newBuilder() {
        return new AuditEventGetAuditActivityTypesParameterSetBuilder();
    }
    /**
     * Fluent builder for the AuditEventGetAuditActivityTypesParameterSet
     */
    public static final class AuditEventGetAuditActivityTypesParameterSetBuilder {
        /**
         * The category parameter value
         */
        @Nullable
        protected String category;
        /**
         * Sets the Category
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AuditEventGetAuditActivityTypesParameterSetBuilder withCategory(@Nullable final String val) {
            this.category = val;
            return this;
        }
        /**
         * Instanciates a new AuditEventGetAuditActivityTypesParameterSetBuilder
         */
        @Nullable
        protected AuditEventGetAuditActivityTypesParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public AuditEventGetAuditActivityTypesParameterSet build() {
            return new AuditEventGetAuditActivityTypesParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.category != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("category", category));
        }
        return result;
    }
}
