// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AppLogDecryptionAlgorithm;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Log Collection Download Details.
 */
public class AppLogCollectionDownloadDetails implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The App Log Decryption Algorithm.
     * Decryption algorithm for Content. Default is ASE256. Possible values are: aes256, unknownFutureValue.
     */
    @SerializedName(value = "appLogDecryptionAlgorithm", alternate = {"AppLogDecryptionAlgorithm"})
    @Expose
	@Nullable
    public AppLogDecryptionAlgorithm appLogDecryptionAlgorithm;

    /**
     * The Decryption Key.
     * Decryption key that used to decrypt the log.
     */
    @SerializedName(value = "decryptionKey", alternate = {"DecryptionKey"})
    @Expose
	@Nullable
    public String decryptionKey;

    /**
     * The Download Url.
     * Download SAS (Shared Access Signature) Url for completed app log request.
     */
    @SerializedName(value = "downloadUrl", alternate = {"DownloadUrl"})
    @Expose
	@Nullable
    public String downloadUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
