// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Instance Batch Record Decisions Parameter Set.
 */
public class AccessReviewInstanceBatchRecordDecisionsParameterSet {
    /**
     * The decision.
     * 
     */
    @SerializedName(value = "decision", alternate = {"Decision"})
    @Expose
	@Nullable
    public String decision;

    /**
     * The justification.
     * 
     */
    @SerializedName(value = "justification", alternate = {"Justification"})
    @Expose
	@Nullable
    public String justification;

    /**
     * The principal Id.
     * 
     */
    @SerializedName(value = "principalId", alternate = {"PrincipalId"})
    @Expose
	@Nullable
    public String principalId;

    /**
     * The resource Id.
     * 
     */
    @SerializedName(value = "resourceId", alternate = {"ResourceId"})
    @Expose
	@Nullable
    public String resourceId;


    /**
     * Instiaciates a new AccessReviewInstanceBatchRecordDecisionsParameterSet
     */
    public AccessReviewInstanceBatchRecordDecisionsParameterSet() {}
    /**
     * Instiaciates a new AccessReviewInstanceBatchRecordDecisionsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected AccessReviewInstanceBatchRecordDecisionsParameterSet(@Nonnull final AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder builder) {
        this.decision = builder.decision;
        this.justification = builder.justification;
        this.principalId = builder.principalId;
        this.resourceId = builder.resourceId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder newBuilder() {
        return new AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder();
    }
    /**
     * Fluent builder for the AccessReviewInstanceBatchRecordDecisionsParameterSet
     */
    public static final class AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder {
        /**
         * The decision parameter value
         */
        @Nullable
        protected String decision;
        /**
         * Sets the Decision
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder withDecision(@Nullable final String val) {
            this.decision = val;
            return this;
        }
        /**
         * The justification parameter value
         */
        @Nullable
        protected String justification;
        /**
         * Sets the Justification
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder withJustification(@Nullable final String val) {
            this.justification = val;
            return this;
        }
        /**
         * The principalId parameter value
         */
        @Nullable
        protected String principalId;
        /**
         * Sets the PrincipalId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder withPrincipalId(@Nullable final String val) {
            this.principalId = val;
            return this;
        }
        /**
         * The resourceId parameter value
         */
        @Nullable
        protected String resourceId;
        /**
         * Sets the ResourceId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder withResourceId(@Nullable final String val) {
            this.resourceId = val;
            return this;
        }
        /**
         * Instanciates a new AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder
         */
        @Nullable
        protected AccessReviewInstanceBatchRecordDecisionsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public AccessReviewInstanceBatchRecordDecisionsParameterSet build() {
            return new AccessReviewInstanceBatchRecordDecisionsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.decision != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("decision", decision));
        }
        if(this.justification != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("justification", justification));
        }
        if(this.principalId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("principalId", principalId));
        }
        if(this.resourceId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("resourceId", resourceId));
        }
        return result;
    }
}
