// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DeletedItemContainer;
import com.microsoft.graph.identitygovernance.models.LifecycleManagementSettings;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionPage;
import com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionPage;
import com.microsoft.graph.identitygovernance.requests.WorkflowCollectionPage;
import com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Lifecycle Workflows Container.
 */
public class LifecycleWorkflowsContainer extends Entity implements IJsonBackedObject {


    /**
     * The Custom Task Extensions.
     * The customTaskExtension instance.
     */
    @SerializedName(value = "customTaskExtensions", alternate = {"CustomTaskExtensions"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionPage customTaskExtensions;

    /**
     * The Deleted Items.
     * Deleted workflows in your lifecycle workflows instance.
     */
    @SerializedName(value = "deletedItems", alternate = {"DeletedItems"})
    @Expose
	@Nullable
    public DeletedItemContainer deletedItems;

    /**
     * The Settings.
     * The settings of the lifecycle workflows instance.
     */
    @SerializedName(value = "settings", alternate = {"Settings"})
    @Expose
	@Nullable
    public LifecycleManagementSettings settings;

    /**
     * The Task Definitions.
     * The definition of tasks within the lifecycle workflows instance.
     */
    @SerializedName(value = "taskDefinitions", alternate = {"TaskDefinitions"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionPage taskDefinitions;

    /**
     * The Workflows.
     * The workflows in the lifecycle workflows instance.
     */
    @SerializedName(value = "workflows", alternate = {"Workflows"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.WorkflowCollectionPage workflows;

    /**
     * The Workflow Templates.
     * The workflow templates in the lifecycle workflow instance.
     */
    @SerializedName(value = "workflowTemplates", alternate = {"WorkflowTemplates"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionPage workflowTemplates;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("customTaskExtensions")) {
            customTaskExtensions = serializer.deserializeObject(json.get("customTaskExtensions"), com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionPage.class);
        }

        if (json.has("taskDefinitions")) {
            taskDefinitions = serializer.deserializeObject(json.get("taskDefinitions"), com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionPage.class);
        }

        if (json.has("workflows")) {
            workflows = serializer.deserializeObject(json.get("workflows"), com.microsoft.graph.identitygovernance.requests.WorkflowCollectionPage.class);
        }

        if (json.has("workflowTemplates")) {
            workflowTemplates = serializer.deserializeObject(json.get("workflowTemplates"), com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionPage.class);
        }
    }
}
