// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.UserSource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Source Request.
 */
public class UserSourceRequest extends BaseRequest<UserSource> {
	
    /**
     * The request for the UserSource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserSourceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserSource.class);
    }

    /**
     * Gets the UserSource from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSource> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserSource from the service
     *
     * @return the UserSource from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSource get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSource> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserSource delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserSource with a source
     *
     * @param sourceUserSource the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSource> patchAsync(@Nonnull final UserSource sourceUserSource) {
        return sendAsync(HttpMethod.PATCH, sourceUserSource);
    }

    /**
     * Patches this UserSource with a source
     *
     * @param sourceUserSource the source object with updates
     * @return the updated UserSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSource patch(@Nonnull final UserSource sourceUserSource) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserSource);
    }

    /**
     * Creates a UserSource with a new object
     *
     * @param newUserSource the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSource> postAsync(@Nonnull final UserSource newUserSource) {
        return sendAsync(HttpMethod.POST, newUserSource);
    }

    /**
     * Creates a UserSource with a new object
     *
     * @param newUserSource the new object to create
     * @return the created UserSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSource post(@Nonnull final UserSource newUserSource) throws ClientException {
        return send(HttpMethod.POST, newUserSource);
    }

    /**
     * Creates a UserSource with a new object
     *
     * @param newUserSource the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserSource> putAsync(@Nonnull final UserSource newUserSource) {
        return sendAsync(HttpMethod.PUT, newUserSource);
    }

    /**
     * Creates a UserSource with a new object
     *
     * @param newUserSource the object to create/update
     * @return the created UserSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserSource put(@Nonnull final UserSource newUserSource) throws ClientException {
        return send(HttpMethod.PUT, newUserSource);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserSourceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserSourceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

