// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.HostPort;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Port Request.
 */
public class HostPortRequest extends BaseRequest<HostPort> {
	
    /**
     * The request for the HostPort
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public HostPortRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostPort.class);
    }

    /**
     * Gets the HostPort from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPort> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the HostPort from the service
     *
     * @return the HostPort from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPort get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPort> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public HostPort delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this HostPort with a source
     *
     * @param sourceHostPort the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPort> patchAsync(@Nonnull final HostPort sourceHostPort) {
        return sendAsync(HttpMethod.PATCH, sourceHostPort);
    }

    /**
     * Patches this HostPort with a source
     *
     * @param sourceHostPort the source object with updates
     * @return the updated HostPort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPort patch(@Nonnull final HostPort sourceHostPort) throws ClientException {
        return send(HttpMethod.PATCH, sourceHostPort);
    }

    /**
     * Creates a HostPort with a new object
     *
     * @param newHostPort the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPort> postAsync(@Nonnull final HostPort newHostPort) {
        return sendAsync(HttpMethod.POST, newHostPort);
    }

    /**
     * Creates a HostPort with a new object
     *
     * @param newHostPort the new object to create
     * @return the created HostPort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPort post(@Nonnull final HostPort newHostPort) throws ClientException {
        return send(HttpMethod.POST, newHostPort);
    }

    /**
     * Creates a HostPort with a new object
     *
     * @param newHostPort the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPort> putAsync(@Nonnull final HostPort newHostPort) {
        return sendAsync(HttpMethod.PUT, newHostPort);
    }

    /**
     * Creates a HostPort with a new object
     *
     * @param newHostPort the object to create/update
     * @return the created HostPort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPort put(@Nonnull final HostPort newHostPort) throws ClientException {
        return send(HttpMethod.PUT, newHostPort);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public HostPortRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public HostPortRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

