// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.HostTracker;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.HostTrackerCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostTrackerCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.HostTrackerCollectionResponse;
import com.microsoft.graph.security.models.HostTracker;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Tracker Collection With References Page.
 */
public class HostTrackerCollectionWithReferencesPage extends BaseCollectionPage<HostTracker, HostTrackerCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for HostTracker
     *
     * @param response the serialized HostTrackerCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public HostTrackerCollectionWithReferencesPage(@Nonnull final HostTrackerCollectionResponse response, @Nullable final HostTrackerCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for HostTracker
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public HostTrackerCollectionWithReferencesPage(@Nonnull final java.util.List<HostTracker> pageContents, @Nullable final HostTrackerCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
