// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookTable;
import com.microsoft.graph.models.WorkbookTableRow;
import com.microsoft.graph.models.WorkbookRange;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.WorkbookTableRowCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRowRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRowCollectionRequest;
import com.microsoft.graph.requests.WorkbookTableRowAddRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRowCountRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRowItemAtRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.WorkbookTableRowAddParameterSet;
import com.microsoft.graph.models.WorkbookTableRowItemAtParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Table Row Collection Request Builder.
 */
public class WorkbookTableRowCollectionRequestBuilder extends BaseCollectionRequestBuilder<WorkbookTableRow, WorkbookTableRowRequestBuilder, WorkbookTableRowCollectionResponse, WorkbookTableRowCollectionPage, WorkbookTableRowCollectionRequest> {

    /**
     * The request builder for this collection of WorkbookTable
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookTableRowCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookTableRowRequestBuilder.class, WorkbookTableRowCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookTableRowAddRequestBuilder add(@Nonnull final WorkbookTableRowAddParameterSet parameters) {
        return new WorkbookTableRowAddRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.add"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkbookTableRowCountRequestBuilder count() {
        return new WorkbookTableRowCountRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.count"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookTableRowItemAtRequestBuilder itemAt(@Nonnull final WorkbookTableRowItemAtParameterSet parameters) {
        return new WorkbookTableRowItemAtRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.itemAt"), getClient(), null, parameters);
    }
}
