// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OnenoteEntitySchemaObjectModel;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Entity Schema Object Model Request.
 */
public class OnenoteEntitySchemaObjectModelRequest extends BaseRequest<OnenoteEntitySchemaObjectModel> {
	
    /**
     * The request for the OnenoteEntitySchemaObjectModel
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public OnenoteEntitySchemaObjectModelRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends OnenoteEntitySchemaObjectModel> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the OnenoteEntitySchemaObjectModel
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenoteEntitySchemaObjectModelRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenoteEntitySchemaObjectModel.class);
    }

    /**
     * Gets the OnenoteEntitySchemaObjectModel from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnenoteEntitySchemaObjectModel> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OnenoteEntitySchemaObjectModel from the service
     *
     * @return the OnenoteEntitySchemaObjectModel from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnenoteEntitySchemaObjectModel get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnenoteEntitySchemaObjectModel> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OnenoteEntitySchemaObjectModel delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OnenoteEntitySchemaObjectModel with a source
     *
     * @param sourceOnenoteEntitySchemaObjectModel the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnenoteEntitySchemaObjectModel> patchAsync(@Nonnull final OnenoteEntitySchemaObjectModel sourceOnenoteEntitySchemaObjectModel) {
        return sendAsync(HttpMethod.PATCH, sourceOnenoteEntitySchemaObjectModel);
    }

    /**
     * Patches this OnenoteEntitySchemaObjectModel with a source
     *
     * @param sourceOnenoteEntitySchemaObjectModel the source object with updates
     * @return the updated OnenoteEntitySchemaObjectModel
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnenoteEntitySchemaObjectModel patch(@Nonnull final OnenoteEntitySchemaObjectModel sourceOnenoteEntitySchemaObjectModel) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnenoteEntitySchemaObjectModel);
    }

    /**
     * Creates a OnenoteEntitySchemaObjectModel with a new object
     *
     * @param newOnenoteEntitySchemaObjectModel the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnenoteEntitySchemaObjectModel> postAsync(@Nonnull final OnenoteEntitySchemaObjectModel newOnenoteEntitySchemaObjectModel) {
        return sendAsync(HttpMethod.POST, newOnenoteEntitySchemaObjectModel);
    }

    /**
     * Creates a OnenoteEntitySchemaObjectModel with a new object
     *
     * @param newOnenoteEntitySchemaObjectModel the new object to create
     * @return the created OnenoteEntitySchemaObjectModel
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnenoteEntitySchemaObjectModel post(@Nonnull final OnenoteEntitySchemaObjectModel newOnenoteEntitySchemaObjectModel) throws ClientException {
        return send(HttpMethod.POST, newOnenoteEntitySchemaObjectModel);
    }

    /**
     * Creates a OnenoteEntitySchemaObjectModel with a new object
     *
     * @param newOnenoteEntitySchemaObjectModel the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnenoteEntitySchemaObjectModel> putAsync(@Nonnull final OnenoteEntitySchemaObjectModel newOnenoteEntitySchemaObjectModel) {
        return sendAsync(HttpMethod.PUT, newOnenoteEntitySchemaObjectModel);
    }

    /**
     * Creates a OnenoteEntitySchemaObjectModel with a new object
     *
     * @param newOnenoteEntitySchemaObjectModel the object to create/update
     * @return the created OnenoteEntitySchemaObjectModel
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnenoteEntitySchemaObjectModel put(@Nonnull final OnenoteEntitySchemaObjectModel newOnenoteEntitySchemaObjectModel) throws ClientException {
        return send(HttpMethod.PUT, newOnenoteEntitySchemaObjectModel);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OnenoteEntitySchemaObjectModelRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OnenoteEntitySchemaObjectModelRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

