// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationStrengthRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Root Request Builder.
 */
public class AuthenticationStrengthRootRequestBuilder extends BaseRequestBuilder<AuthenticationStrengthRoot> {

    /**
     * The request builder for the AuthenticationStrengthRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationStrengthRootRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AuthenticationStrengthRootRequest instance
     */
    @Nonnull
    public AuthenticationStrengthRootRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the AuthenticationStrengthRootRequest instance
     */
    @Nonnull
    public AuthenticationStrengthRootRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.AuthenticationStrengthRootRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the AuthenticationMethodModeDetail collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodModeDetailCollectionRequestBuilder authenticationMethodModes() {
        return new com.microsoft.graph.requests.AuthenticationMethodModeDetailCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationMethodModes"), getClient(), null);
    }

    /**
     * Gets a request builder for the AuthenticationMethodModeDetail item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodModeDetailRequestBuilder authenticationMethodModes(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AuthenticationMethodModeDetailRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationMethodModes") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AuthenticationStrengthPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationStrengthPolicyCollectionRequestBuilder policies() {
        return new com.microsoft.graph.requests.AuthenticationStrengthPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("policies"), getClient(), null);
    }

    /**
     * Gets a request builder for the AuthenticationStrengthPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationStrengthPolicyRequestBuilder policies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AuthenticationStrengthPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("policies") + "/" + id, getClient(), null);
    }
}
