// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ScheduleRequestActions;
import com.microsoft.graph.models.RequestSchedule;
import com.microsoft.graph.models.TicketInfo;
import com.microsoft.graph.models.Request;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Schedule Request.
 */
public class PrivilegedAccessScheduleRequest extends Request implements IJsonBackedObject {


    /**
     * The Action.
     * Represents the type of operation on the group membership or ownership assignment request. The possible values are: adminAssign, adminUpdate, adminRemove, selfActivate, selfDeactivate, adminExtend, adminRenew. adminAssign: For administrators to assign group membership or ownership to principals.adminRemove: For administrators to remove principals from group membership or ownership. adminUpdate: For administrators to change existing group membership or ownership assignments.adminExtend: For administrators to extend expiring assignments.adminRenew: For administrators to renew expired assignments.selfActivate: For principals to activate their assignments.selfDeactivate: For principals to deactivate their active assignments.
     */
    @SerializedName(value = "action", alternate = {"Action"})
    @Expose
	@Nullable
    public ScheduleRequestActions action;

    /**
     * The Is Validation Only.
     * Determines whether the call is a validation or an actual call. Only set this property if you want to check whether an activation is subject to additional rules like MFA before actually submitting the request.
     */
    @SerializedName(value = "isValidationOnly", alternate = {"IsValidationOnly"})
    @Expose
	@Nullable
    public Boolean isValidationOnly;

    /**
     * The Justification.
     * A message provided by users and administrators when create they create the privilegedAccessGroupAssignmentScheduleRequest object.
     */
    @SerializedName(value = "justification", alternate = {"Justification"})
    @Expose
	@Nullable
    public String justification;

    /**
     * The Schedule Info.
     * The period of the group membership or ownership assignment. Recurring schedules are currently unsupported.
     */
    @SerializedName(value = "scheduleInfo", alternate = {"ScheduleInfo"})
    @Expose
	@Nullable
    public RequestSchedule scheduleInfo;

    /**
     * The Ticket Info.
     * Ticket details linked to the group membership or ownership assignment request including details of the ticket number and ticket system.
     */
    @SerializedName(value = "ticketInfo", alternate = {"TicketInfo"})
    @Expose
	@Nullable
    public TicketInfo ticketInfo;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
