// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.WindowsMalwareExecutionState;
import com.microsoft.graph.models.WindowsMalwareThreatState;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Malware State For Windows Device.
 */
public class MalwareStateForWindowsDevice extends Entity implements IJsonBackedObject {


    /**
     * The Detection Count.
     * Indicates the number of times the malware is detected
     */
    @SerializedName(value = "detectionCount", alternate = {"DetectionCount"})
    @Expose
	@Nullable
    public Integer detectionCount;

    /**
     * The Device Name.
     * Indicates the name of the device being evaluated for malware state
     */
    @SerializedName(value = "deviceName", alternate = {"DeviceName"})
    @Expose
	@Nullable
    public String deviceName;

    /**
     * The Execution State.
     * Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
     */
    @SerializedName(value = "executionState", alternate = {"ExecutionState"})
    @Expose
	@Nullable
    public WindowsMalwareExecutionState executionState;

    /**
     * The Initial Detection Date Time.
     * Initial detection datetime of the malware
     */
    @SerializedName(value = "initialDetectionDateTime", alternate = {"InitialDetectionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime initialDetectionDateTime;

    /**
     * The Last State Change Date Time.
     * The last time this particular threat was changed
     */
    @SerializedName(value = "lastStateChangeDateTime", alternate = {"LastStateChangeDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastStateChangeDateTime;

    /**
     * The Threat State.
     * Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     */
    @SerializedName(value = "threatState", alternate = {"ThreatState"})
    @Expose
	@Nullable
    public WindowsMalwareThreatState threatState;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
