// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.graph.models.AuthenticationStrengthPolicyType;
import com.microsoft.graph.models.AuthenticationStrengthRequirements;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AuthenticationCombinationConfigurationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Policy.
 */
public class AuthenticationStrengthPolicy extends Entity implements IJsonBackedObject {


    /**
     * The Allowed Combinations.
     * A collection of authentication method modes that are required be used to satify this authentication strength.
     */
    @SerializedName(value = "allowedCombinations", alternate = {"AllowedCombinations"})
    @Expose
	@Nullable
    public java.util.List<EnumSet<AuthenticationMethodModes>> allowedCombinations;

    /**
     * The Created Date Time.
     * The datetime when this policy was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * The human-readable description of this policy.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The human-readable display name of this policy. Supports $filter (eq, ne, not , and in).
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Modified Date Time.
     * The datetime when this policy was last modified.
     */
    @SerializedName(value = "modifiedDateTime", alternate = {"ModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime modifiedDateTime;

    /**
     * The Policy Type.
     * A descriptor of whether this policy is built into Microsoft Entra ID or created by an admin for the tenant. The possible values are: builtIn, custom, unknownFutureValue. Supports $filter (eq, ne, not , and in).
     */
    @SerializedName(value = "policyType", alternate = {"PolicyType"})
    @Expose
	@Nullable
    public AuthenticationStrengthPolicyType policyType;

    /**
     * The Requirements Satisfied.
     * A descriptor of whether this authentication strength grants the MFA claim upon successful satisfaction. The possible values are: none, mfa, unknownFutureValue.
     */
    @SerializedName(value = "requirementsSatisfied", alternate = {"RequirementsSatisfied"})
    @Expose
	@Nullable
    public EnumSet<AuthenticationStrengthRequirements> requirementsSatisfied;

    /**
     * The Combination Configurations.
     * Settings that may be used to require specific types or instances of an authentication method to be used when authenticating with a specified combination of authentication methods.
     */
    @SerializedName(value = "combinationConfigurations", alternate = {"CombinationConfigurations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AuthenticationCombinationConfigurationCollectionPage combinationConfigurations;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("combinationConfigurations")) {
            combinationConfigurations = serializer.deserializeObject(json.get("combinationConfigurations"), com.microsoft.graph.requests.AuthenticationCombinationConfigurationCollectionPage.class);
        }
    }
}
