// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.TaskProcessingResult;
import com.microsoft.graph.identitygovernance.models.CustomTaskExtensionCallbackData;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.identitygovernance.models.TaskProcessingResultResumeParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task Processing Result Request Builder.
 */
public class TaskProcessingResultRequestBuilder extends BaseRequestBuilder<TaskProcessingResult> {

    /**
     * The request builder for the TaskProcessingResult
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TaskProcessingResultRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the TaskProcessingResultRequest instance
     */
    @Nonnull
    public TaskProcessingResultRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the TaskProcessingResultRequest instance
     */
    @Nonnull
    public TaskProcessingResultRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.identitygovernance.requests.TaskProcessingResultRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for User
     *
     * @return the UserWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.UserWithReferenceRequestBuilder subject() {
        return new com.microsoft.graph.requests.UserWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("subject"), getClient(), null);
    }

    /**
     * Gets the request builder for Task
     *
     * @return the TaskWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskWithReferenceRequestBuilder task() {
        return new com.microsoft.graph.identitygovernance.requests.TaskWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("task"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public TaskProcessingResultResumeRequestBuilder resume(@Nonnull final TaskProcessingResultResumeParameterSet parameters) {
        return new TaskProcessingResultResumeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.identityGovernance.resume"), getClient(), null, parameters);
    }
}
