// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Users Processing Summary.
 */
public class UsersProcessingSummary implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Failed Tasks.
     * 
     */
    @SerializedName(value = "failedTasks", alternate = {"FailedTasks"})
    @Expose
	@Nullable
    public Integer failedTasks;

    /**
     * The Failed Users.
     * 
     */
    @SerializedName(value = "failedUsers", alternate = {"FailedUsers"})
    @Expose
	@Nullable
    public Integer failedUsers;

    /**
     * The Successful Users.
     * 
     */
    @SerializedName(value = "successfulUsers", alternate = {"SuccessfulUsers"})
    @Expose
	@Nullable
    public Integer successfulUsers;

    /**
     * The Total Tasks.
     * 
     */
    @SerializedName(value = "totalTasks", alternate = {"TotalTasks"})
    @Expose
	@Nullable
    public Integer totalTasks;

    /**
     * The Total Users.
     * 
     */
    @SerializedName(value = "totalUsers", alternate = {"TotalUsers"})
    @Expose
	@Nullable
    public Integer totalUsers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
