// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.Subdomain;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.SubdomainCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.SubdomainCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.SubdomainCollectionResponse;
import com.microsoft.graph.security.models.Subdomain;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subdomain Collection With References Page.
 */
public class SubdomainCollectionWithReferencesPage extends BaseCollectionPage<Subdomain, SubdomainCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for Subdomain
     *
     * @param response the serialized SubdomainCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public SubdomainCollectionWithReferencesPage(@Nonnull final SubdomainCollectionResponse response, @Nullable final SubdomainCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for Subdomain
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public SubdomainCollectionWithReferencesPage(@Nonnull final java.util.List<Subdomain> pageContents, @Nullable final SubdomainCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
