// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessGroupAssignmentSchedule;
import com.microsoft.graph.models.AssignmentScheduleFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Assignment Schedule Request.
 */
public class PrivilegedAccessGroupAssignmentScheduleRequest extends BaseRequest<PrivilegedAccessGroupAssignmentSchedule> {
	
    /**
     * The request for the PrivilegedAccessGroupAssignmentSchedule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupAssignmentScheduleRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupAssignmentSchedule.class);
    }

    /**
     * Gets the PrivilegedAccessGroupAssignmentSchedule from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentSchedule> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrivilegedAccessGroupAssignmentSchedule from the service
     *
     * @return the PrivilegedAccessGroupAssignmentSchedule from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentSchedule get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentSchedule> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentSchedule delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrivilegedAccessGroupAssignmentSchedule with a source
     *
     * @param sourcePrivilegedAccessGroupAssignmentSchedule the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentSchedule> patchAsync(@Nonnull final PrivilegedAccessGroupAssignmentSchedule sourcePrivilegedAccessGroupAssignmentSchedule) {
        return sendAsync(HttpMethod.PATCH, sourcePrivilegedAccessGroupAssignmentSchedule);
    }

    /**
     * Patches this PrivilegedAccessGroupAssignmentSchedule with a source
     *
     * @param sourcePrivilegedAccessGroupAssignmentSchedule the source object with updates
     * @return the updated PrivilegedAccessGroupAssignmentSchedule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentSchedule patch(@Nonnull final PrivilegedAccessGroupAssignmentSchedule sourcePrivilegedAccessGroupAssignmentSchedule) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivilegedAccessGroupAssignmentSchedule);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentSchedule with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentSchedule the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentSchedule> postAsync(@Nonnull final PrivilegedAccessGroupAssignmentSchedule newPrivilegedAccessGroupAssignmentSchedule) {
        return sendAsync(HttpMethod.POST, newPrivilegedAccessGroupAssignmentSchedule);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentSchedule with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentSchedule the new object to create
     * @return the created PrivilegedAccessGroupAssignmentSchedule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentSchedule post(@Nonnull final PrivilegedAccessGroupAssignmentSchedule newPrivilegedAccessGroupAssignmentSchedule) throws ClientException {
        return send(HttpMethod.POST, newPrivilegedAccessGroupAssignmentSchedule);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentSchedule with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentSchedule the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentSchedule> putAsync(@Nonnull final PrivilegedAccessGroupAssignmentSchedule newPrivilegedAccessGroupAssignmentSchedule) {
        return sendAsync(HttpMethod.PUT, newPrivilegedAccessGroupAssignmentSchedule);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentSchedule with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentSchedule the object to create/update
     * @return the created PrivilegedAccessGroupAssignmentSchedule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentSchedule put(@Nonnull final PrivilegedAccessGroupAssignmentSchedule newPrivilegedAccessGroupAssignmentSchedule) throws ClientException {
        return send(HttpMethod.PUT, newPrivilegedAccessGroupAssignmentSchedule);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupAssignmentScheduleRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupAssignmentScheduleRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

