// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ManagedDeviceMobileAppConfigurationDeviceSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Mobile App Configuration Device Summary Request.
 */
public class ManagedDeviceMobileAppConfigurationDeviceSummaryRequest extends BaseRequest<ManagedDeviceMobileAppConfigurationDeviceSummary> {
	
    /**
     * The request for the ManagedDeviceMobileAppConfigurationDeviceSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceMobileAppConfigurationDeviceSummaryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDeviceMobileAppConfigurationDeviceSummary.class);
    }

    /**
     * Gets the ManagedDeviceMobileAppConfigurationDeviceSummary from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceMobileAppConfigurationDeviceSummary> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ManagedDeviceMobileAppConfigurationDeviceSummary from the service
     *
     * @return the ManagedDeviceMobileAppConfigurationDeviceSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceMobileAppConfigurationDeviceSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceMobileAppConfigurationDeviceSummary> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ManagedDeviceMobileAppConfigurationDeviceSummary delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedDeviceMobileAppConfigurationDeviceSummary with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationDeviceSummary the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceMobileAppConfigurationDeviceSummary> patchAsync(@Nonnull final ManagedDeviceMobileAppConfigurationDeviceSummary sourceManagedDeviceMobileAppConfigurationDeviceSummary) {
        return sendAsync(HttpMethod.PATCH, sourceManagedDeviceMobileAppConfigurationDeviceSummary);
    }

    /**
     * Patches this ManagedDeviceMobileAppConfigurationDeviceSummary with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationDeviceSummary the source object with updates
     * @return the updated ManagedDeviceMobileAppConfigurationDeviceSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceMobileAppConfigurationDeviceSummary patch(@Nonnull final ManagedDeviceMobileAppConfigurationDeviceSummary sourceManagedDeviceMobileAppConfigurationDeviceSummary) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedDeviceMobileAppConfigurationDeviceSummary);
    }

    /**
     * Creates a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceMobileAppConfigurationDeviceSummary> postAsync(@Nonnull final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary) {
        return sendAsync(HttpMethod.POST, newManagedDeviceMobileAppConfigurationDeviceSummary);
    }

    /**
     * Creates a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the new object to create
     * @return the created ManagedDeviceMobileAppConfigurationDeviceSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceMobileAppConfigurationDeviceSummary post(@Nonnull final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary) throws ClientException {
        return send(HttpMethod.POST, newManagedDeviceMobileAppConfigurationDeviceSummary);
    }

    /**
     * Creates a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceMobileAppConfigurationDeviceSummary> putAsync(@Nonnull final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary) {
        return sendAsync(HttpMethod.PUT, newManagedDeviceMobileAppConfigurationDeviceSummary);
    }

    /**
     * Creates a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the object to create/update
     * @return the created ManagedDeviceMobileAppConfigurationDeviceSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceMobileAppConfigurationDeviceSummary put(@Nonnull final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary) throws ClientException {
        return send(HttpMethod.PUT, newManagedDeviceMobileAppConfigurationDeviceSummary);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ManagedDeviceMobileAppConfigurationDeviceSummaryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ManagedDeviceMobileAppConfigurationDeviceSummaryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

