// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LandingPage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Landing Page Request.
 */
public class LandingPageRequest extends BaseRequest<LandingPage> {
	
    /**
     * The request for the LandingPage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LandingPageRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LandingPage.class);
    }

    /**
     * Gets the LandingPage from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LandingPage> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LandingPage from the service
     *
     * @return the LandingPage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LandingPage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LandingPage> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LandingPage delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LandingPage with a source
     *
     * @param sourceLandingPage the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LandingPage> patchAsync(@Nonnull final LandingPage sourceLandingPage) {
        return sendAsync(HttpMethod.PATCH, sourceLandingPage);
    }

    /**
     * Patches this LandingPage with a source
     *
     * @param sourceLandingPage the source object with updates
     * @return the updated LandingPage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LandingPage patch(@Nonnull final LandingPage sourceLandingPage) throws ClientException {
        return send(HttpMethod.PATCH, sourceLandingPage);
    }

    /**
     * Creates a LandingPage with a new object
     *
     * @param newLandingPage the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LandingPage> postAsync(@Nonnull final LandingPage newLandingPage) {
        return sendAsync(HttpMethod.POST, newLandingPage);
    }

    /**
     * Creates a LandingPage with a new object
     *
     * @param newLandingPage the new object to create
     * @return the created LandingPage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LandingPage post(@Nonnull final LandingPage newLandingPage) throws ClientException {
        return send(HttpMethod.POST, newLandingPage);
    }

    /**
     * Creates a LandingPage with a new object
     *
     * @param newLandingPage the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LandingPage> putAsync(@Nonnull final LandingPage newLandingPage) {
        return sendAsync(HttpMethod.PUT, newLandingPage);
    }

    /**
     * Creates a LandingPage with a new object
     *
     * @param newLandingPage the object to create/update
     * @return the created LandingPage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LandingPage put(@Nonnull final LandingPage newLandingPage) throws ClientException {
        return send(HttpMethod.PUT, newLandingPage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LandingPageRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LandingPageRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

