// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingStaffMemberBase;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Staff Member Base Request.
 */
public class BookingStaffMemberBaseRequest extends BaseRequest<BookingStaffMemberBase> {
	
    /**
     * The request for the BookingStaffMemberBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public BookingStaffMemberBaseRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends BookingStaffMemberBase> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the BookingStaffMemberBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingStaffMemberBaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingStaffMemberBase.class);
    }

    /**
     * Gets the BookingStaffMemberBase from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMemberBase> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BookingStaffMemberBase from the service
     *
     * @return the BookingStaffMemberBase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMemberBase get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMemberBase> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BookingStaffMemberBase delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BookingStaffMemberBase with a source
     *
     * @param sourceBookingStaffMemberBase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMemberBase> patchAsync(@Nonnull final BookingStaffMemberBase sourceBookingStaffMemberBase) {
        return sendAsync(HttpMethod.PATCH, sourceBookingStaffMemberBase);
    }

    /**
     * Patches this BookingStaffMemberBase with a source
     *
     * @param sourceBookingStaffMemberBase the source object with updates
     * @return the updated BookingStaffMemberBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMemberBase patch(@Nonnull final BookingStaffMemberBase sourceBookingStaffMemberBase) throws ClientException {
        return send(HttpMethod.PATCH, sourceBookingStaffMemberBase);
    }

    /**
     * Creates a BookingStaffMemberBase with a new object
     *
     * @param newBookingStaffMemberBase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMemberBase> postAsync(@Nonnull final BookingStaffMemberBase newBookingStaffMemberBase) {
        return sendAsync(HttpMethod.POST, newBookingStaffMemberBase);
    }

    /**
     * Creates a BookingStaffMemberBase with a new object
     *
     * @param newBookingStaffMemberBase the new object to create
     * @return the created BookingStaffMemberBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMemberBase post(@Nonnull final BookingStaffMemberBase newBookingStaffMemberBase) throws ClientException {
        return send(HttpMethod.POST, newBookingStaffMemberBase);
    }

    /**
     * Creates a BookingStaffMemberBase with a new object
     *
     * @param newBookingStaffMemberBase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMemberBase> putAsync(@Nonnull final BookingStaffMemberBase newBookingStaffMemberBase) {
        return sendAsync(HttpMethod.PUT, newBookingStaffMemberBase);
    }

    /**
     * Creates a BookingStaffMemberBase with a new object
     *
     * @param newBookingStaffMemberBase the object to create/update
     * @return the created BookingStaffMemberBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMemberBase put(@Nonnull final BookingStaffMemberBase newBookingStaffMemberBase) throws ClientException {
        return send(HttpMethod.PUT, newBookingStaffMemberBase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BookingStaffMemberBaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BookingStaffMemberBaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

