// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;

import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AuditEventGetAuditActivityTypesCollectionRequestBuilder;
import com.microsoft.graph.requests.AuditEventGetAuditActivityTypesCollectionRequest;
import com.microsoft.graph.requests.AuditEventGetAuditActivityTypesCollectionResponse;
import com.microsoft.graph.models.AuditEventGetAuditActivityTypesParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audit Event Get Audit Activity Types Collection Request Builder.
 */
public class AuditEventGetAuditActivityTypesCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<String, AuditEventGetAuditActivityTypesCollectionRequestBuilder, AuditEventGetAuditActivityTypesCollectionResponse, AuditEventGetAuditActivityTypesCollectionPage, AuditEventGetAuditActivityTypesCollectionRequest> {

    /**
     * The request builder for this collection of AuditEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuditEventGetAuditActivityTypesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuditEventGetAuditActivityTypesCollectionRequestBuilder.class, AuditEventGetAuditActivityTypesCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AuditEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AuditEventGetAuditActivityTypesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AuditEventGetAuditActivityTypesParameterSet parameters) {
        super(requestUrl, client, requestOptions, AuditEventGetAuditActivityTypesCollectionRequestBuilder.class, AuditEventGetAuditActivityTypesCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AuditEventGetAuditActivityTypesCollectionRequest instance
     */
    @Override
    @Nonnull
    public AuditEventGetAuditActivityTypesCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AuditEventGetAuditActivityTypesCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
