// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.SynchronizationSecretKeyStringValuePair;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Job Validate Credentials Parameter Set.
 */
public class SynchronizationJobValidateCredentialsParameterSet {
    /**
     * The application Identifier.
     * 
     */
    @SerializedName(value = "applicationIdentifier", alternate = {"ApplicationIdentifier"})
    @Expose
	@Nullable
    public String applicationIdentifier;

    /**
     * The template Id.
     * 
     */
    @SerializedName(value = "templateId", alternate = {"TemplateId"})
    @Expose
	@Nullable
    public String templateId;

    /**
     * The use Saved Credentials.
     * 
     */
    @SerializedName(value = "useSavedCredentials", alternate = {"UseSavedCredentials"})
    @Expose
	@Nullable
    public Boolean useSavedCredentials;

    /**
     * The credentials.
     * 
     */
    @SerializedName(value = "credentials", alternate = {"Credentials"})
    @Expose
	@Nullable
    public java.util.List<SynchronizationSecretKeyStringValuePair> credentials;


    /**
     * Instiaciates a new SynchronizationJobValidateCredentialsParameterSet
     */
    public SynchronizationJobValidateCredentialsParameterSet() {}
    /**
     * Instiaciates a new SynchronizationJobValidateCredentialsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected SynchronizationJobValidateCredentialsParameterSet(@Nonnull final SynchronizationJobValidateCredentialsParameterSetBuilder builder) {
        this.applicationIdentifier = builder.applicationIdentifier;
        this.templateId = builder.templateId;
        this.useSavedCredentials = builder.useSavedCredentials;
        this.credentials = builder.credentials;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static SynchronizationJobValidateCredentialsParameterSetBuilder newBuilder() {
        return new SynchronizationJobValidateCredentialsParameterSetBuilder();
    }
    /**
     * Fluent builder for the SynchronizationJobValidateCredentialsParameterSet
     */
    public static final class SynchronizationJobValidateCredentialsParameterSetBuilder {
        /**
         * The applicationIdentifier parameter value
         */
        @Nullable
        protected String applicationIdentifier;
        /**
         * Sets the ApplicationIdentifier
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SynchronizationJobValidateCredentialsParameterSetBuilder withApplicationIdentifier(@Nullable final String val) {
            this.applicationIdentifier = val;
            return this;
        }
        /**
         * The templateId parameter value
         */
        @Nullable
        protected String templateId;
        /**
         * Sets the TemplateId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SynchronizationJobValidateCredentialsParameterSetBuilder withTemplateId(@Nullable final String val) {
            this.templateId = val;
            return this;
        }
        /**
         * The useSavedCredentials parameter value
         */
        @Nullable
        protected Boolean useSavedCredentials;
        /**
         * Sets the UseSavedCredentials
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SynchronizationJobValidateCredentialsParameterSetBuilder withUseSavedCredentials(@Nullable final Boolean val) {
            this.useSavedCredentials = val;
            return this;
        }
        /**
         * The credentials parameter value
         */
        @Nullable
        protected java.util.List<SynchronizationSecretKeyStringValuePair> credentials;
        /**
         * Sets the Credentials
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SynchronizationJobValidateCredentialsParameterSetBuilder withCredentials(@Nullable final java.util.List<SynchronizationSecretKeyStringValuePair> val) {
            this.credentials = val;
            return this;
        }
        /**
         * Instanciates a new SynchronizationJobValidateCredentialsParameterSetBuilder
         */
        @Nullable
        protected SynchronizationJobValidateCredentialsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public SynchronizationJobValidateCredentialsParameterSet build() {
            return new SynchronizationJobValidateCredentialsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.applicationIdentifier != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("applicationIdentifier", applicationIdentifier));
        }
        if(this.templateId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("templateId", templateId));
        }
        if(this.useSavedCredentials != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("useSavedCredentials", useSavedCredentials));
        }
        if(this.credentials != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("credentials", credentials));
        }
        return result;
    }
}
