/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.ArticleIndicator;
import com.microsoft.graph.security.requests.ArticleIndicatorCollectionPage;
import com.microsoft.graph.security.requests.ArticleIndicatorCollectionRequestBuilder;
import com.microsoft.graph.security.requests.ArticleIndicatorCollectionResponse;
import com.microsoft.graph.security.requests.ArticleIndicatorRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArticleIndicatorCollectionRequest
extends BaseEntityCollectionRequest<ArticleIndicator, ArticleIndicatorCollectionResponse, ArticleIndicatorCollectionPage> {
    public ArticleIndicatorCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ArticleIndicatorCollectionResponse.class, ArticleIndicatorCollectionPage.class, ArticleIndicatorCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ArticleIndicator> postAsync(@Nonnull ArticleIndicator newArticleIndicator) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ArticleIndicatorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newArticleIndicator);
    }

    @Nonnull
    public ArticleIndicator post(@Nonnull ArticleIndicator newArticleIndicator) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ArticleIndicatorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newArticleIndicator);
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ArticleIndicatorCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

