/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.UserCollectionResponse;
import com.microsoft.graph.requests.UserCollectionWithReferencesPage;
import com.microsoft.graph.requests.UserCollectionWithReferencesRequest;
import com.microsoft.graph.requests.UserCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.UserReferenceRequestBuilder;
import com.microsoft.graph.requests.UserWithReferenceRequest;
import com.microsoft.graph.requests.UserWithReferenceRequestBuilder;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserCollectionReferenceRequest
extends BaseCollectionWithReferencesRequest<User, UserWithReferenceRequest, UserReferenceRequestBuilder, UserWithReferenceRequestBuilder, UserCollectionResponse, UserCollectionWithReferencesPage, UserCollectionWithReferencesRequest> {
    public UserCollectionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserCollectionResponse.class, UserCollectionWithReferencesPage.class, UserCollectionWithReferencesRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<User> postAsync(@Nonnull User newUser) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/users/" + newUser.id);
        return ((UserWithReferenceRequest)new UserWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).postAsync(newUser, (IJsonBackedObject)body);
    }

    @Nonnull
    public User post(@Nonnull User newUser) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/users/" + newUser.id);
        return (User)((UserWithReferenceRequest)new UserWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).post(newUser, (IJsonBackedObject)body);
    }

    @Nonnull
    public UserCollectionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public UserCollectionReferenceRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public UserCollectionReferenceRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public UserCollectionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public UserCollectionReferenceRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public UserCollectionReferenceRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public UserCollectionReferenceRequest count() {
        this.addCountOption(true);
        return this;
    }
}

