/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SiteRequest
extends BaseRequest<Site> {
    public SiteRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Site.class);
    }

    @Nonnull
    public CompletableFuture<Site> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Site get() throws ClientException {
        return (Site)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Site> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Site delete() throws ClientException {
        return (Site)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Site> patchAsync(@Nonnull Site sourceSite) {
        return this.sendAsync(HttpMethod.PATCH, sourceSite);
    }

    @Nullable
    public Site patch(@Nonnull Site sourceSite) throws ClientException {
        return (Site)this.send(HttpMethod.PATCH, sourceSite);
    }

    @Nonnull
    public CompletableFuture<Site> postAsync(@Nonnull Site newSite) {
        return this.sendAsync(HttpMethod.POST, newSite);
    }

    @Nullable
    public Site post(@Nonnull Site newSite) throws ClientException {
        return (Site)this.send(HttpMethod.POST, newSite);
    }

    @Nonnull
    public CompletableFuture<Site> putAsync(@Nonnull Site newSite) {
        return this.sendAsync(HttpMethod.PUT, newSite);
    }

    @Nullable
    public Site put(@Nonnull Site newSite) throws ClientException {
        return (Site)this.send(HttpMethod.PUT, newSite);
    }

    @Nonnull
    public SiteRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SiteRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

