/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirectoryObjectReferenceRequest
extends BaseReferenceRequest<DirectoryObject> {
    public DirectoryObjectReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObject.class);
    }

    @Nonnull
    public DirectoryObjectReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<DirectoryObject> putAsync(@Nonnull DirectoryObject srcDirectoryObject) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/directoryObjects/" + srcDirectoryObject.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public DirectoryObject put(@Nonnull DirectoryObject srcDirectoryObject) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/directoryObjects/" + srcDirectoryObject.id));
        return (DirectoryObject)this.send(HttpMethod.PUT, payload);
    }
}

