// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Vulnerability;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Vulnerability Request.
 */
public class VulnerabilityRequest extends BaseRequest<Vulnerability> {
	
    /**
     * The request for the Vulnerability
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VulnerabilityRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Vulnerability.class);
    }

    /**
     * Gets the Vulnerability from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Vulnerability> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Vulnerability from the service
     *
     * @return the Vulnerability from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Vulnerability get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Vulnerability> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Vulnerability delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Vulnerability with a source
     *
     * @param sourceVulnerability the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Vulnerability> patchAsync(@Nonnull final Vulnerability sourceVulnerability) {
        return sendAsync(HttpMethod.PATCH, sourceVulnerability);
    }

    /**
     * Patches this Vulnerability with a source
     *
     * @param sourceVulnerability the source object with updates
     * @return the updated Vulnerability
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Vulnerability patch(@Nonnull final Vulnerability sourceVulnerability) throws ClientException {
        return send(HttpMethod.PATCH, sourceVulnerability);
    }

    /**
     * Creates a Vulnerability with a new object
     *
     * @param newVulnerability the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Vulnerability> postAsync(@Nonnull final Vulnerability newVulnerability) {
        return sendAsync(HttpMethod.POST, newVulnerability);
    }

    /**
     * Creates a Vulnerability with a new object
     *
     * @param newVulnerability the new object to create
     * @return the created Vulnerability
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Vulnerability post(@Nonnull final Vulnerability newVulnerability) throws ClientException {
        return send(HttpMethod.POST, newVulnerability);
    }

    /**
     * Creates a Vulnerability with a new object
     *
     * @param newVulnerability the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Vulnerability> putAsync(@Nonnull final Vulnerability newVulnerability) {
        return sendAsync(HttpMethod.PUT, newVulnerability);
    }

    /**
     * Creates a Vulnerability with a new object
     *
     * @param newVulnerability the object to create/update
     * @return the created Vulnerability
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Vulnerability put(@Nonnull final Vulnerability newVulnerability) throws ClientException {
        return send(HttpMethod.PUT, newVulnerability);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VulnerabilityRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VulnerabilityRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

