// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.PassiveDnsRecord;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Passive Dns Record Request Builder.
 */
public class PassiveDnsRecordRequestBuilder extends BaseRequestBuilder<PassiveDnsRecord> {

    /**
     * The request builder for the PassiveDnsRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PassiveDnsRecordRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PassiveDnsRecordRequest instance
     */
    @Nonnull
    public PassiveDnsRecordRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PassiveDnsRecordRequest instance
     */
    @Nonnull
    public PassiveDnsRecordRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.security.requests.PassiveDnsRecordRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for Artifact
     *
     * @return the ArtifactWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.security.requests.ArtifactWithReferenceRequestBuilder artifact() {
        return new com.microsoft.graph.security.requests.ArtifactWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("artifact"), getClient(), null);
    }

    /**
     * Gets the request builder for Host
     *
     * @return the HostWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostWithReferenceRequestBuilder parentHost() {
        return new com.microsoft.graph.security.requests.HostWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("parentHost"), getClient(), null);
    }
}
