// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.TriggerTypesRoot;
import com.microsoft.graph.security.models.RetentionEventType;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.RetentionEventTypeCollectionRequestBuilder;
import com.microsoft.graph.security.requests.RetentionEventTypeRequestBuilder;
import com.microsoft.graph.security.requests.RetentionEventTypeCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Retention Event Type Collection Request Builder.
 */
public class RetentionEventTypeCollectionRequestBuilder extends BaseCollectionRequestBuilder<RetentionEventType, RetentionEventTypeRequestBuilder, RetentionEventTypeCollectionResponse, RetentionEventTypeCollectionPage, RetentionEventTypeCollectionRequest> {

    /**
     * The request builder for this collection of TriggerTypesRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RetentionEventTypeCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RetentionEventTypeRequestBuilder.class, RetentionEventTypeCollectionRequest.class);
    }



    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
