// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceLogCollectionResponse;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Log Collection Response Request.
 */
public class DeviceLogCollectionResponseRequest extends BaseRequest<DeviceLogCollectionResponse> {
	
    /**
     * The request for the DeviceLogCollectionResponse
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceLogCollectionResponseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceLogCollectionResponse.class);
    }

    /**
     * Gets the DeviceLogCollectionResponse from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceLogCollectionResponse> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceLogCollectionResponse from the service
     *
     * @return the DeviceLogCollectionResponse from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceLogCollectionResponse get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceLogCollectionResponse> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceLogCollectionResponse delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceLogCollectionResponse with a source
     *
     * @param sourceDeviceLogCollectionResponse the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceLogCollectionResponse> patchAsync(@Nonnull final DeviceLogCollectionResponse sourceDeviceLogCollectionResponse) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceLogCollectionResponse);
    }

    /**
     * Patches this DeviceLogCollectionResponse with a source
     *
     * @param sourceDeviceLogCollectionResponse the source object with updates
     * @return the updated DeviceLogCollectionResponse
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceLogCollectionResponse patch(@Nonnull final DeviceLogCollectionResponse sourceDeviceLogCollectionResponse) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceLogCollectionResponse);
    }

    /**
     * Creates a DeviceLogCollectionResponse with a new object
     *
     * @param newDeviceLogCollectionResponse the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceLogCollectionResponse> postAsync(@Nonnull final DeviceLogCollectionResponse newDeviceLogCollectionResponse) {
        return sendAsync(HttpMethod.POST, newDeviceLogCollectionResponse);
    }

    /**
     * Creates a DeviceLogCollectionResponse with a new object
     *
     * @param newDeviceLogCollectionResponse the new object to create
     * @return the created DeviceLogCollectionResponse
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceLogCollectionResponse post(@Nonnull final DeviceLogCollectionResponse newDeviceLogCollectionResponse) throws ClientException {
        return send(HttpMethod.POST, newDeviceLogCollectionResponse);
    }

    /**
     * Creates a DeviceLogCollectionResponse with a new object
     *
     * @param newDeviceLogCollectionResponse the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceLogCollectionResponse> putAsync(@Nonnull final DeviceLogCollectionResponse newDeviceLogCollectionResponse) {
        return sendAsync(HttpMethod.PUT, newDeviceLogCollectionResponse);
    }

    /**
     * Creates a DeviceLogCollectionResponse with a new object
     *
     * @param newDeviceLogCollectionResponse the object to create/update
     * @return the created DeviceLogCollectionResponse
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceLogCollectionResponse put(@Nonnull final DeviceLogCollectionResponse newDeviceLogCollectionResponse) throws ClientException {
        return send(HttpMethod.PUT, newDeviceLogCollectionResponse);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceLogCollectionResponseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceLogCollectionResponseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

