// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceManagement;
import com.microsoft.graph.models.AuditEvent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AuditEventCollectionRequestBuilder;
import com.microsoft.graph.requests.AuditEventRequestBuilder;
import com.microsoft.graph.requests.AuditEventCollectionRequest;
import com.microsoft.graph.requests.AuditEventGetAuditActivityTypesCollectionRequestBuilder;
import com.microsoft.graph.requests.AuditEventGetAuditCategoriesCollectionRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.AuditEventGetAuditActivityTypesParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audit Event Collection Request Builder.
 */
public class AuditEventCollectionRequestBuilder extends BaseCollectionRequestBuilder<AuditEvent, AuditEventRequestBuilder, AuditEventCollectionResponse, AuditEventCollectionPage, AuditEventCollectionRequest> {

    /**
     * The request builder for this collection of DeviceManagement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuditEventCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuditEventRequestBuilder.class, AuditEventCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder collection
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public AuditEventGetAuditActivityTypesCollectionRequestBuilder getAuditActivityTypes(@Nonnull final AuditEventGetAuditActivityTypesParameterSet parameters) {
        return new AuditEventGetAuditActivityTypesCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getAuditActivityTypes"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder collection
     */
    @Nonnull
    public AuditEventGetAuditCategoriesCollectionRequestBuilder getAuditCategories() {
        return new AuditEventGetAuditCategoriesCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getAuditCategories"), getClient(), null);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
