// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Autopilot Device Identity Assign User To Device Parameter Set.
 */
public class WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet {
    /**
     * The user Principal Name.
     * 
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;

    /**
     * The addressable User Name.
     * 
     */
    @SerializedName(value = "addressableUserName", alternate = {"AddressableUserName"})
    @Expose
	@Nullable
    public String addressableUserName;


    /**
     * Instiaciates a new WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet
     */
    public WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet() {}
    /**
     * Instiaciates a new WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet(@Nonnull final WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder builder) {
        this.userPrincipalName = builder.userPrincipalName;
        this.addressableUserName = builder.addressableUserName;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder newBuilder() {
        return new WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder();
    }
    /**
     * Fluent builder for the WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet
     */
    public static final class WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder {
        /**
         * The userPrincipalName parameter value
         */
        @Nullable
        protected String userPrincipalName;
        /**
         * Sets the UserPrincipalName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder withUserPrincipalName(@Nullable final String val) {
            this.userPrincipalName = val;
            return this;
        }
        /**
         * The addressableUserName parameter value
         */
        @Nullable
        protected String addressableUserName;
        /**
         * Sets the AddressableUserName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder withAddressableUserName(@Nullable final String val) {
            this.addressableUserName = val;
            return this;
        }
        /**
         * Instanciates a new WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder
         */
        @Nullable
        protected WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet build() {
            return new WindowsAutopilotDeviceIdentityAssignUserToDeviceParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.userPrincipalName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("userPrincipalName", userPrincipalName));
        }
        if(this.addressableUserName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("addressableUserName", addressableUserName));
        }
        return result;
    }
}
