/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.BrowserSiteList;
import com.microsoft.graph.models.BrowserSiteListPublishParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.BrowserSharedCookieCollectionRequestBuilder;
import com.microsoft.graph.requests.BrowserSharedCookieRequestBuilder;
import com.microsoft.graph.requests.BrowserSiteCollectionRequestBuilder;
import com.microsoft.graph.requests.BrowserSiteListPublishRequestBuilder;
import com.microsoft.graph.requests.BrowserSiteListRequest;
import com.microsoft.graph.requests.BrowserSiteRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BrowserSiteListRequestBuilder
extends BaseRequestBuilder<BrowserSiteList> {
    public BrowserSiteListRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public BrowserSiteListRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public BrowserSiteListRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new BrowserSiteListRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public BrowserSharedCookieCollectionRequestBuilder sharedCookies() {
        return new BrowserSharedCookieCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("sharedCookies"), this.getClient(), null);
    }

    @Nonnull
    public BrowserSharedCookieRequestBuilder sharedCookies(@Nonnull String id) {
        return new BrowserSharedCookieRequestBuilder(this.getRequestUrlWithAdditionalSegment("sharedCookies") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public BrowserSiteCollectionRequestBuilder sites() {
        return new BrowserSiteCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("sites"), this.getClient(), null);
    }

    @Nonnull
    public BrowserSiteRequestBuilder sites(@Nonnull String id) {
        return new BrowserSiteRequestBuilder(this.getRequestUrlWithAdditionalSegment("sites") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public BrowserSiteListPublishRequestBuilder publish(@Nonnull BrowserSiteListPublishParameterSet parameters) {
        return new BrowserSiteListPublishRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.publish"), this.getClient(), null, parameters);
    }
}

