// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.termstore.models.Term;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Term Request Builder.
 */
public class TermRequestBuilder extends BaseRequestBuilder<Term> {

    /**
     * The request builder for the Term
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TermRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the TermRequest instance
     */
    @Nonnull
    public TermRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the TermRequest instance
     */
    @Nonnull
    public TermRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.termstore.requests.TermRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the Term collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.TermCollectionRequestBuilder children() {
        return new com.microsoft.graph.termstore.requests.TermCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("children"), getClient(), null);
    }

    /**
     * Gets a request builder for the Term item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.TermRequestBuilder children(@Nonnull final String id) {
        return new com.microsoft.graph.termstore.requests.TermRequestBuilder(getRequestUrlWithAdditionalSegment("children") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Relation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.RelationCollectionRequestBuilder relations() {
        return new com.microsoft.graph.termstore.requests.RelationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("relations"), getClient(), null);
    }

    /**
     * Gets a request builder for the Relation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.RelationRequestBuilder relations(@Nonnull final String id) {
        return new com.microsoft.graph.termstore.requests.RelationRequestBuilder(getRequestUrlWithAdditionalSegment("relations") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for Set
     *
     * @return the SetWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.SetWithReferenceRequestBuilder set() {
        return new com.microsoft.graph.termstore.requests.SetWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("set"), getClient(), null);
    }
}
