// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.RetentionEvent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Retention Event Request.
 */
public class RetentionEventRequest extends BaseRequest<RetentionEvent> {
	
    /**
     * The request for the RetentionEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RetentionEventRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RetentionEvent.class);
    }

    /**
     * Gets the RetentionEvent from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RetentionEvent> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the RetentionEvent from the service
     *
     * @return the RetentionEvent from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RetentionEvent get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RetentionEvent> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public RetentionEvent delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RetentionEvent with a source
     *
     * @param sourceRetentionEvent the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RetentionEvent> patchAsync(@Nonnull final RetentionEvent sourceRetentionEvent) {
        return sendAsync(HttpMethod.PATCH, sourceRetentionEvent);
    }

    /**
     * Patches this RetentionEvent with a source
     *
     * @param sourceRetentionEvent the source object with updates
     * @return the updated RetentionEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RetentionEvent patch(@Nonnull final RetentionEvent sourceRetentionEvent) throws ClientException {
        return send(HttpMethod.PATCH, sourceRetentionEvent);
    }

    /**
     * Creates a RetentionEvent with a new object
     *
     * @param newRetentionEvent the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RetentionEvent> postAsync(@Nonnull final RetentionEvent newRetentionEvent) {
        return sendAsync(HttpMethod.POST, newRetentionEvent);
    }

    /**
     * Creates a RetentionEvent with a new object
     *
     * @param newRetentionEvent the new object to create
     * @return the created RetentionEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RetentionEvent post(@Nonnull final RetentionEvent newRetentionEvent) throws ClientException {
        return send(HttpMethod.POST, newRetentionEvent);
    }

    /**
     * Creates a RetentionEvent with a new object
     *
     * @param newRetentionEvent the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RetentionEvent> putAsync(@Nonnull final RetentionEvent newRetentionEvent) {
        return sendAsync(HttpMethod.PUT, newRetentionEvent);
    }

    /**
     * Creates a RetentionEvent with a new object
     *
     * @param newRetentionEvent the object to create/update
     * @return the created RetentionEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RetentionEvent put(@Nonnull final RetentionEvent newRetentionEvent) throws ClientException {
        return send(HttpMethod.PUT, newRetentionEvent);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RetentionEventRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RetentionEventRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

