// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.IntelligenceProfileIndicator;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Intelligence Profile Indicator Request.
 */
public class IntelligenceProfileIndicatorRequest extends BaseRequest<IntelligenceProfileIndicator> {
	
    /**
     * The request for the IntelligenceProfileIndicator
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IntelligenceProfileIndicatorRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IntelligenceProfileIndicator.class);
    }

    /**
     * Gets the IntelligenceProfileIndicator from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfileIndicator> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IntelligenceProfileIndicator from the service
     *
     * @return the IntelligenceProfileIndicator from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfileIndicator get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfileIndicator> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IntelligenceProfileIndicator delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IntelligenceProfileIndicator with a source
     *
     * @param sourceIntelligenceProfileIndicator the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfileIndicator> patchAsync(@Nonnull final IntelligenceProfileIndicator sourceIntelligenceProfileIndicator) {
        return sendAsync(HttpMethod.PATCH, sourceIntelligenceProfileIndicator);
    }

    /**
     * Patches this IntelligenceProfileIndicator with a source
     *
     * @param sourceIntelligenceProfileIndicator the source object with updates
     * @return the updated IntelligenceProfileIndicator
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfileIndicator patch(@Nonnull final IntelligenceProfileIndicator sourceIntelligenceProfileIndicator) throws ClientException {
        return send(HttpMethod.PATCH, sourceIntelligenceProfileIndicator);
    }

    /**
     * Creates a IntelligenceProfileIndicator with a new object
     *
     * @param newIntelligenceProfileIndicator the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfileIndicator> postAsync(@Nonnull final IntelligenceProfileIndicator newIntelligenceProfileIndicator) {
        return sendAsync(HttpMethod.POST, newIntelligenceProfileIndicator);
    }

    /**
     * Creates a IntelligenceProfileIndicator with a new object
     *
     * @param newIntelligenceProfileIndicator the new object to create
     * @return the created IntelligenceProfileIndicator
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfileIndicator post(@Nonnull final IntelligenceProfileIndicator newIntelligenceProfileIndicator) throws ClientException {
        return send(HttpMethod.POST, newIntelligenceProfileIndicator);
    }

    /**
     * Creates a IntelligenceProfileIndicator with a new object
     *
     * @param newIntelligenceProfileIndicator the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfileIndicator> putAsync(@Nonnull final IntelligenceProfileIndicator newIntelligenceProfileIndicator) {
        return sendAsync(HttpMethod.PUT, newIntelligenceProfileIndicator);
    }

    /**
     * Creates a IntelligenceProfileIndicator with a new object
     *
     * @param newIntelligenceProfileIndicator the object to create/update
     * @return the created IntelligenceProfileIndicator
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfileIndicator put(@Nonnull final IntelligenceProfileIndicator newIntelligenceProfileIndicator) throws ClientException {
        return send(HttpMethod.PUT, newIntelligenceProfileIndicator);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IntelligenceProfileIndicatorRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IntelligenceProfileIndicatorRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

