// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.PurgeType;
import com.microsoft.graph.security.models.PurgeAreas;
import java.util.EnumSet;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.security.models.EdiscoverySearchPurgeDataParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Search Request Builder.
 */
public class EdiscoverySearchRequestBuilder extends BaseRequestBuilder<EdiscoverySearch> {

    /**
     * The request builder for the EdiscoverySearch
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoverySearchRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the EdiscoverySearchRequest instance
     */
    @Nonnull
    public EdiscoverySearchRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the EdiscoverySearchRequest instance
     */
    @Nonnull
    public EdiscoverySearchRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.security.requests.EdiscoverySearchRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the DataSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.DataSourceCollectionRequestBuilder additionalSources() {
        return new com.microsoft.graph.security.requests.DataSourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("additionalSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the DataSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.DataSourceRequestBuilder additionalSources(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.DataSourceRequestBuilder(getRequestUrlWithAdditionalSegment("additionalSources") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for EdiscoveryAddToReviewSetOperation
     *
     * @return the EdiscoveryAddToReviewSetOperationWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.security.requests.EdiscoveryAddToReviewSetOperationWithReferenceRequestBuilder addToReviewSetOperation() {
        return new com.microsoft.graph.security.requests.EdiscoveryAddToReviewSetOperationWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("addToReviewSetOperation"), getClient(), null);
    }
    /**
     *  Gets a request builder for the DataSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.DataSourceCollectionWithReferencesRequestBuilder custodianSources() {
        return new com.microsoft.graph.security.requests.DataSourceCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("custodianSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the DataSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.DataSourceWithReferenceRequestBuilder custodianSources(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.DataSourceWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("custodianSources") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for EdiscoveryEstimateOperation
     *
     * @return the EdiscoveryEstimateOperationWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.security.requests.EdiscoveryEstimateOperationWithReferenceRequestBuilder lastEstimateStatisticsOperation() {
        return new com.microsoft.graph.security.requests.EdiscoveryEstimateOperationWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("lastEstimateStatisticsOperation"), getClient(), null);
    }
    /**
     *  Gets a request builder for the EdiscoveryNoncustodialDataSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionWithReferencesRequestBuilder noncustodialSources() {
        return new com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("noncustodialSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the EdiscoveryNoncustodialDataSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceWithReferenceRequestBuilder noncustodialSources(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("noncustodialSources") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public EdiscoverySearchEstimateStatisticsRequestBuilder estimateStatistics() {
        return new EdiscoverySearchEstimateStatisticsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.security.estimateStatistics"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public EdiscoverySearchPurgeDataRequestBuilder purgeData(@Nonnull final EdiscoverySearchPurgeDataParameterSet parameters) {
        return new EdiscoverySearchPurgeDataRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.security.purgeData"), getClient(), null, parameters);
    }
}
