// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryPurgeDataOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Purge Data Operation Request.
 */
public class EdiscoveryPurgeDataOperationRequest extends BaseRequest<EdiscoveryPurgeDataOperation> {
	
    /**
     * The request for the EdiscoveryPurgeDataOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryPurgeDataOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryPurgeDataOperation.class);
    }

    /**
     * Gets the EdiscoveryPurgeDataOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryPurgeDataOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryPurgeDataOperation from the service
     *
     * @return the EdiscoveryPurgeDataOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryPurgeDataOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryPurgeDataOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryPurgeDataOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryPurgeDataOperation with a source
     *
     * @param sourceEdiscoveryPurgeDataOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryPurgeDataOperation> patchAsync(@Nonnull final EdiscoveryPurgeDataOperation sourceEdiscoveryPurgeDataOperation) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryPurgeDataOperation);
    }

    /**
     * Patches this EdiscoveryPurgeDataOperation with a source
     *
     * @param sourceEdiscoveryPurgeDataOperation the source object with updates
     * @return the updated EdiscoveryPurgeDataOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryPurgeDataOperation patch(@Nonnull final EdiscoveryPurgeDataOperation sourceEdiscoveryPurgeDataOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryPurgeDataOperation);
    }

    /**
     * Creates a EdiscoveryPurgeDataOperation with a new object
     *
     * @param newEdiscoveryPurgeDataOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryPurgeDataOperation> postAsync(@Nonnull final EdiscoveryPurgeDataOperation newEdiscoveryPurgeDataOperation) {
        return sendAsync(HttpMethod.POST, newEdiscoveryPurgeDataOperation);
    }

    /**
     * Creates a EdiscoveryPurgeDataOperation with a new object
     *
     * @param newEdiscoveryPurgeDataOperation the new object to create
     * @return the created EdiscoveryPurgeDataOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryPurgeDataOperation post(@Nonnull final EdiscoveryPurgeDataOperation newEdiscoveryPurgeDataOperation) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryPurgeDataOperation);
    }

    /**
     * Creates a EdiscoveryPurgeDataOperation with a new object
     *
     * @param newEdiscoveryPurgeDataOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryPurgeDataOperation> putAsync(@Nonnull final EdiscoveryPurgeDataOperation newEdiscoveryPurgeDataOperation) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryPurgeDataOperation);
    }

    /**
     * Creates a EdiscoveryPurgeDataOperation with a new object
     *
     * @param newEdiscoveryPurgeDataOperation the object to create/update
     * @return the created EdiscoveryPurgeDataOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryPurgeDataOperation put(@Nonnull final EdiscoveryPurgeDataOperation newEdiscoveryPurgeDataOperation) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryPurgeDataOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryPurgeDataOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryPurgeDataOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

