// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryIndexOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Index Operation Request.
 */
public class EdiscoveryIndexOperationRequest extends BaseRequest<EdiscoveryIndexOperation> {
	
    /**
     * The request for the EdiscoveryIndexOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryIndexOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryIndexOperation.class);
    }

    /**
     * Gets the EdiscoveryIndexOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryIndexOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryIndexOperation from the service
     *
     * @return the EdiscoveryIndexOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryIndexOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryIndexOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryIndexOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryIndexOperation with a source
     *
     * @param sourceEdiscoveryIndexOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryIndexOperation> patchAsync(@Nonnull final EdiscoveryIndexOperation sourceEdiscoveryIndexOperation) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryIndexOperation);
    }

    /**
     * Patches this EdiscoveryIndexOperation with a source
     *
     * @param sourceEdiscoveryIndexOperation the source object with updates
     * @return the updated EdiscoveryIndexOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryIndexOperation patch(@Nonnull final EdiscoveryIndexOperation sourceEdiscoveryIndexOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryIndexOperation);
    }

    /**
     * Creates a EdiscoveryIndexOperation with a new object
     *
     * @param newEdiscoveryIndexOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryIndexOperation> postAsync(@Nonnull final EdiscoveryIndexOperation newEdiscoveryIndexOperation) {
        return sendAsync(HttpMethod.POST, newEdiscoveryIndexOperation);
    }

    /**
     * Creates a EdiscoveryIndexOperation with a new object
     *
     * @param newEdiscoveryIndexOperation the new object to create
     * @return the created EdiscoveryIndexOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryIndexOperation post(@Nonnull final EdiscoveryIndexOperation newEdiscoveryIndexOperation) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryIndexOperation);
    }

    /**
     * Creates a EdiscoveryIndexOperation with a new object
     *
     * @param newEdiscoveryIndexOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryIndexOperation> putAsync(@Nonnull final EdiscoveryIndexOperation newEdiscoveryIndexOperation) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryIndexOperation);
    }

    /**
     * Creates a EdiscoveryIndexOperation with a new object
     *
     * @param newEdiscoveryIndexOperation the object to create/update
     * @return the created EdiscoveryIndexOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryIndexOperation put(@Nonnull final EdiscoveryIndexOperation newEdiscoveryIndexOperation) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryIndexOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryIndexOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryIndexOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

