// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.DataSource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Data Source Request.
 */
public class DataSourceRequest extends BaseRequest<DataSource> {
	
    /**
     * The request for the DataSource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public DataSourceRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends DataSource> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the DataSource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DataSourceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DataSource.class);
    }

    /**
     * Gets the DataSource from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSource> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DataSource from the service
     *
     * @return the DataSource from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSource get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSource> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DataSource delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DataSource with a source
     *
     * @param sourceDataSource the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSource> patchAsync(@Nonnull final DataSource sourceDataSource) {
        return sendAsync(HttpMethod.PATCH, sourceDataSource);
    }

    /**
     * Patches this DataSource with a source
     *
     * @param sourceDataSource the source object with updates
     * @return the updated DataSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSource patch(@Nonnull final DataSource sourceDataSource) throws ClientException {
        return send(HttpMethod.PATCH, sourceDataSource);
    }

    /**
     * Creates a DataSource with a new object
     *
     * @param newDataSource the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSource> postAsync(@Nonnull final DataSource newDataSource) {
        return sendAsync(HttpMethod.POST, newDataSource);
    }

    /**
     * Creates a DataSource with a new object
     *
     * @param newDataSource the new object to create
     * @return the created DataSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSource post(@Nonnull final DataSource newDataSource) throws ClientException {
        return send(HttpMethod.POST, newDataSource);
    }

    /**
     * Creates a DataSource with a new object
     *
     * @param newDataSource the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSource> putAsync(@Nonnull final DataSource newDataSource) {
        return sendAsync(HttpMethod.PUT, newDataSource);
    }

    /**
     * Creates a DataSource with a new object
     *
     * @param newDataSource the object to create/update
     * @return the created DataSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSource put(@Nonnull final DataSource newDataSource) throws ClientException {
        return send(HttpMethod.PUT, newDataSource);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DataSourceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DataSourceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

