// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.CvssSummary;
import com.microsoft.graph.security.models.FormattedContent;
import com.microsoft.graph.security.models.Hyperlink;
import com.microsoft.graph.security.models.VulnerabilitySeverity;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.security.requests.ArticleCollectionPage;
import com.microsoft.graph.security.requests.VulnerabilityComponentCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Vulnerability.
 */
public class Vulnerability extends Entity implements IJsonBackedObject {


    /**
     * The Active Exploits Observed.
     * Indicates whether this vulnerability has any known exploits associated to known bad actors.
     */
    @SerializedName(value = "activeExploitsObserved", alternate = {"ActiveExploitsObserved"})
    @Expose
	@Nullable
    public Boolean activeExploitsObserved;

    /**
     * The Common Weakness Enumeration Ids.
     * Community-defined common weakness enumerations (CWE).
     */
    @SerializedName(value = "commonWeaknessEnumerationIds", alternate = {"CommonWeaknessEnumerationIds"})
    @Expose
	@Nullable
    public java.util.List<String> commonWeaknessEnumerationIds;

    /**
     * The Created Date Time.
     * The date and time when this vulnerability article was first created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Cvss2Summary.
     * A summary of the common vulnerability scoring system (v2) findings about this vulnerability.
     */
    @SerializedName(value = "cvss2Summary", alternate = {"Cvss2Summary"})
    @Expose
	@Nullable
    public CvssSummary cvss2Summary;

    /**
     * The Cvss3Summary.
     * A summary of the common vulnerability scoring system (v3) findings about this vulnerability.
     */
    @SerializedName(value = "cvss3Summary", alternate = {"Cvss3Summary"})
    @Expose
	@Nullable
    public CvssSummary cvss3Summary;

    /**
     * The Description.
     * The vulnerability article contents, describing the vulnerability.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public FormattedContent description;

    /**
     * The Exploits.
     * Known exploits for this vulnerability.
     */
    @SerializedName(value = "exploits", alternate = {"Exploits"})
    @Expose
	@Nullable
    public java.util.List<Hyperlink> exploits;

    /**
     * The Exploits Available.
     * Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
     */
    @SerializedName(value = "exploitsAvailable", alternate = {"ExploitsAvailable"})
    @Expose
	@Nullable
    public Boolean exploitsAvailable;

    /**
     * The Has Chatter.
     * Indicates whether chatter about this vulnerability has been discovered online.
     */
    @SerializedName(value = "hasChatter", alternate = {"HasChatter"})
    @Expose
	@Nullable
    public Boolean hasChatter;

    /**
     * The Last Modified Date Time.
     * The date and time when this vulnerability article was most recently updated.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Priority Score.
     * A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
     */
    @SerializedName(value = "priorityScore", alternate = {"PriorityScore"})
    @Expose
	@Nullable
    public Integer priorityScore;

    /**
     * The Published Date Time.
     * The date and time when this vulnerability article was published.
     */
    @SerializedName(value = "publishedDateTime", alternate = {"PublishedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime publishedDateTime;

    /**
     * The References.
     * Reference links where further information can be learned about this vulnerability.
     */
    @SerializedName(value = "references", alternate = {"References"})
    @Expose
	@Nullable
    public java.util.List<Hyperlink> references;

    /**
     * The Remediation.
     * Any known remediation steps.
     */
    @SerializedName(value = "remediation", alternate = {"Remediation"})
    @Expose
	@Nullable
    public FormattedContent remediation;

    /**
     * The Severity.
     * Indicates the severity of this vulnerability. The possible values are: none, low, medium, high, critical, unknownFutureValue.
     */
    @SerializedName(value = "severity", alternate = {"Severity"})
    @Expose
	@Nullable
    public VulnerabilitySeverity severity;

    /**
     * The Articles.
     * Articles related to this vulnerability.
     */
	@Nullable
    public com.microsoft.graph.security.requests.ArticleCollectionPage articles;

    /**
     * The Components.
     * Components related to this vulnerability article.
     */
    @SerializedName(value = "components", alternate = {"Components"})
    @Expose
	@Nullable
    public com.microsoft.graph.security.requests.VulnerabilityComponentCollectionPage components;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("articles")) {
            articles = serializer.deserializeObject(json.get("articles"), com.microsoft.graph.security.requests.ArticleCollectionPage.class);
        }

        if (json.has("components")) {
            components = serializer.deserializeObject(json.get("components"), com.microsoft.graph.security.requests.VulnerabilityComponentCollectionPage.class);
        }
    }
}
