// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.EdiscoveryReviewSet;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.CaseOperation;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Add To Review Set Operation.
 */
public class EdiscoveryAddToReviewSetOperation extends CaseOperation implements IJsonBackedObject {


    /**
     * The Review Set.
     * eDiscovery review set to which items matching source collection query gets added.
     */
    @SerializedName(value = "reviewSet", alternate = {"ReviewSet"})
    @Expose
	@Nullable
    public EdiscoveryReviewSet reviewSet;

    /**
     * The Search.
     * eDiscovery search that gets added to review set.
     */
    @SerializedName(value = "search", alternate = {"Search"})
    @Expose
	@Nullable
    public EdiscoverySearch search;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
