// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.X509CertificateAuthenticationMethodConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the X509Certificate Authentication Method Configuration Request.
 */
public class X509CertificateAuthenticationMethodConfigurationRequest extends BaseRequest<X509CertificateAuthenticationMethodConfiguration> {
	
    /**
     * The request for the X509CertificateAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public X509CertificateAuthenticationMethodConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, X509CertificateAuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the X509CertificateAuthenticationMethodConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<X509CertificateAuthenticationMethodConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the X509CertificateAuthenticationMethodConfiguration from the service
     *
     * @return the X509CertificateAuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public X509CertificateAuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<X509CertificateAuthenticationMethodConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public X509CertificateAuthenticationMethodConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this X509CertificateAuthenticationMethodConfiguration with a source
     *
     * @param sourceX509CertificateAuthenticationMethodConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<X509CertificateAuthenticationMethodConfiguration> patchAsync(@Nonnull final X509CertificateAuthenticationMethodConfiguration sourceX509CertificateAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceX509CertificateAuthenticationMethodConfiguration);
    }

    /**
     * Patches this X509CertificateAuthenticationMethodConfiguration with a source
     *
     * @param sourceX509CertificateAuthenticationMethodConfiguration the source object with updates
     * @return the updated X509CertificateAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public X509CertificateAuthenticationMethodConfiguration patch(@Nonnull final X509CertificateAuthenticationMethodConfiguration sourceX509CertificateAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceX509CertificateAuthenticationMethodConfiguration);
    }

    /**
     * Creates a X509CertificateAuthenticationMethodConfiguration with a new object
     *
     * @param newX509CertificateAuthenticationMethodConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<X509CertificateAuthenticationMethodConfiguration> postAsync(@Nonnull final X509CertificateAuthenticationMethodConfiguration newX509CertificateAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.POST, newX509CertificateAuthenticationMethodConfiguration);
    }

    /**
     * Creates a X509CertificateAuthenticationMethodConfiguration with a new object
     *
     * @param newX509CertificateAuthenticationMethodConfiguration the new object to create
     * @return the created X509CertificateAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public X509CertificateAuthenticationMethodConfiguration post(@Nonnull final X509CertificateAuthenticationMethodConfiguration newX509CertificateAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newX509CertificateAuthenticationMethodConfiguration);
    }

    /**
     * Creates a X509CertificateAuthenticationMethodConfiguration with a new object
     *
     * @param newX509CertificateAuthenticationMethodConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<X509CertificateAuthenticationMethodConfiguration> putAsync(@Nonnull final X509CertificateAuthenticationMethodConfiguration newX509CertificateAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PUT, newX509CertificateAuthenticationMethodConfiguration);
    }

    /**
     * Creates a X509CertificateAuthenticationMethodConfiguration with a new object
     *
     * @param newX509CertificateAuthenticationMethodConfiguration the object to create/update
     * @return the created X509CertificateAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public X509CertificateAuthenticationMethodConfiguration put(@Nonnull final X509CertificateAuthenticationMethodConfiguration newX509CertificateAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newX509CertificateAuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public X509CertificateAuthenticationMethodConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public X509CertificateAuthenticationMethodConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

