// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsAppX;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows App XRequest.
 */
public class WindowsAppXRequest extends BaseRequest<WindowsAppX> {
	
    /**
     * The request for the WindowsAppX
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsAppXRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsAppX.class);
    }

    /**
     * Gets the WindowsAppX from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAppX> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsAppX from the service
     *
     * @return the WindowsAppX from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAppX get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAppX> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsAppX delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsAppX with a source
     *
     * @param sourceWindowsAppX the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAppX> patchAsync(@Nonnull final WindowsAppX sourceWindowsAppX) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsAppX);
    }

    /**
     * Patches this WindowsAppX with a source
     *
     * @param sourceWindowsAppX the source object with updates
     * @return the updated WindowsAppX
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAppX patch(@Nonnull final WindowsAppX sourceWindowsAppX) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsAppX);
    }

    /**
     * Creates a WindowsAppX with a new object
     *
     * @param newWindowsAppX the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAppX> postAsync(@Nonnull final WindowsAppX newWindowsAppX) {
        return sendAsync(HttpMethod.POST, newWindowsAppX);
    }

    /**
     * Creates a WindowsAppX with a new object
     *
     * @param newWindowsAppX the new object to create
     * @return the created WindowsAppX
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAppX post(@Nonnull final WindowsAppX newWindowsAppX) throws ClientException {
        return send(HttpMethod.POST, newWindowsAppX);
    }

    /**
     * Creates a WindowsAppX with a new object
     *
     * @param newWindowsAppX the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAppX> putAsync(@Nonnull final WindowsAppX newWindowsAppX) {
        return sendAsync(HttpMethod.PUT, newWindowsAppX);
    }

    /**
     * Creates a WindowsAppX with a new object
     *
     * @param newWindowsAppX the object to create/update
     * @return the created WindowsAppX
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAppX put(@Nonnull final WindowsAppX newWindowsAppX) throws ClientException {
        return send(HttpMethod.PUT, newWindowsAppX);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsAppXRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsAppXRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

