// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsOverview;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Overview Request.
 */
public class UserExperienceAnalyticsOverviewRequest extends BaseRequest<UserExperienceAnalyticsOverview> {
	
    /**
     * The request for the UserExperienceAnalyticsOverview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsOverviewRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsOverview.class);
    }

    /**
     * Gets the UserExperienceAnalyticsOverview from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsOverview> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsOverview from the service
     *
     * @return the UserExperienceAnalyticsOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsOverview get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsOverview> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsOverview delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsOverview with a source
     *
     * @param sourceUserExperienceAnalyticsOverview the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsOverview> patchAsync(@Nonnull final UserExperienceAnalyticsOverview sourceUserExperienceAnalyticsOverview) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsOverview);
    }

    /**
     * Patches this UserExperienceAnalyticsOverview with a source
     *
     * @param sourceUserExperienceAnalyticsOverview the source object with updates
     * @return the updated UserExperienceAnalyticsOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsOverview patch(@Nonnull final UserExperienceAnalyticsOverview sourceUserExperienceAnalyticsOverview) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsOverview);
    }

    /**
     * Creates a UserExperienceAnalyticsOverview with a new object
     *
     * @param newUserExperienceAnalyticsOverview the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsOverview> postAsync(@Nonnull final UserExperienceAnalyticsOverview newUserExperienceAnalyticsOverview) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsOverview);
    }

    /**
     * Creates a UserExperienceAnalyticsOverview with a new object
     *
     * @param newUserExperienceAnalyticsOverview the new object to create
     * @return the created UserExperienceAnalyticsOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsOverview post(@Nonnull final UserExperienceAnalyticsOverview newUserExperienceAnalyticsOverview) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsOverview);
    }

    /**
     * Creates a UserExperienceAnalyticsOverview with a new object
     *
     * @param newUserExperienceAnalyticsOverview the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsOverview> putAsync(@Nonnull final UserExperienceAnalyticsOverview newUserExperienceAnalyticsOverview) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsOverview);
    }

    /**
     * Creates a UserExperienceAnalyticsOverview with a new object
     *
     * @param newUserExperienceAnalyticsOverview the object to create/update
     * @return the created UserExperienceAnalyticsOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsOverview put(@Nonnull final UserExperienceAnalyticsOverview newUserExperienceAnalyticsOverview) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsOverview);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsOverviewRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsOverviewRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

