// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnifiedRoleManagementPolicyNotificationRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Management Policy Notification Rule Request.
 */
public class UnifiedRoleManagementPolicyNotificationRuleRequest extends BaseRequest<UnifiedRoleManagementPolicyNotificationRule> {
	
    /**
     * The request for the UnifiedRoleManagementPolicyNotificationRule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleManagementPolicyNotificationRuleRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleManagementPolicyNotificationRule.class);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyNotificationRule from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyNotificationRule> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyNotificationRule from the service
     *
     * @return the UnifiedRoleManagementPolicyNotificationRule from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyNotificationRule get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyNotificationRule> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnifiedRoleManagementPolicyNotificationRule delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyNotificationRule with a source
     *
     * @param sourceUnifiedRoleManagementPolicyNotificationRule the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyNotificationRule> patchAsync(@Nonnull final UnifiedRoleManagementPolicyNotificationRule sourceUnifiedRoleManagementPolicyNotificationRule) {
        return sendAsync(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyNotificationRule);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyNotificationRule with a source
     *
     * @param sourceUnifiedRoleManagementPolicyNotificationRule the source object with updates
     * @return the updated UnifiedRoleManagementPolicyNotificationRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyNotificationRule patch(@Nonnull final UnifiedRoleManagementPolicyNotificationRule sourceUnifiedRoleManagementPolicyNotificationRule) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyNotificationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyNotificationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyNotificationRule the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyNotificationRule> postAsync(@Nonnull final UnifiedRoleManagementPolicyNotificationRule newUnifiedRoleManagementPolicyNotificationRule) {
        return sendAsync(HttpMethod.POST, newUnifiedRoleManagementPolicyNotificationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyNotificationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyNotificationRule the new object to create
     * @return the created UnifiedRoleManagementPolicyNotificationRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyNotificationRule post(@Nonnull final UnifiedRoleManagementPolicyNotificationRule newUnifiedRoleManagementPolicyNotificationRule) throws ClientException {
        return send(HttpMethod.POST, newUnifiedRoleManagementPolicyNotificationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyNotificationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyNotificationRule the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyNotificationRule> putAsync(@Nonnull final UnifiedRoleManagementPolicyNotificationRule newUnifiedRoleManagementPolicyNotificationRule) {
        return sendAsync(HttpMethod.PUT, newUnifiedRoleManagementPolicyNotificationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyNotificationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyNotificationRule the object to create/update
     * @return the created UnifiedRoleManagementPolicyNotificationRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyNotificationRule put(@Nonnull final UnifiedRoleManagementPolicyNotificationRule newUnifiedRoleManagementPolicyNotificationRule) throws ClientException {
        return send(HttpMethod.PUT, newUnifiedRoleManagementPolicyNotificationRule);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyNotificationRuleRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyNotificationRuleRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

