// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnifiedRoleManagementPolicyExpirationRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Management Policy Expiration Rule Request.
 */
public class UnifiedRoleManagementPolicyExpirationRuleRequest extends BaseRequest<UnifiedRoleManagementPolicyExpirationRule> {
	
    /**
     * The request for the UnifiedRoleManagementPolicyExpirationRule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleManagementPolicyExpirationRuleRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleManagementPolicyExpirationRule.class);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyExpirationRule from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyExpirationRule> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyExpirationRule from the service
     *
     * @return the UnifiedRoleManagementPolicyExpirationRule from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyExpirationRule get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyExpirationRule> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnifiedRoleManagementPolicyExpirationRule delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyExpirationRule with a source
     *
     * @param sourceUnifiedRoleManagementPolicyExpirationRule the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyExpirationRule> patchAsync(@Nonnull final UnifiedRoleManagementPolicyExpirationRule sourceUnifiedRoleManagementPolicyExpirationRule) {
        return sendAsync(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyExpirationRule);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyExpirationRule with a source
     *
     * @param sourceUnifiedRoleManagementPolicyExpirationRule the source object with updates
     * @return the updated UnifiedRoleManagementPolicyExpirationRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyExpirationRule patch(@Nonnull final UnifiedRoleManagementPolicyExpirationRule sourceUnifiedRoleManagementPolicyExpirationRule) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyExpirationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyExpirationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyExpirationRule the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyExpirationRule> postAsync(@Nonnull final UnifiedRoleManagementPolicyExpirationRule newUnifiedRoleManagementPolicyExpirationRule) {
        return sendAsync(HttpMethod.POST, newUnifiedRoleManagementPolicyExpirationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyExpirationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyExpirationRule the new object to create
     * @return the created UnifiedRoleManagementPolicyExpirationRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyExpirationRule post(@Nonnull final UnifiedRoleManagementPolicyExpirationRule newUnifiedRoleManagementPolicyExpirationRule) throws ClientException {
        return send(HttpMethod.POST, newUnifiedRoleManagementPolicyExpirationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyExpirationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyExpirationRule the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyExpirationRule> putAsync(@Nonnull final UnifiedRoleManagementPolicyExpirationRule newUnifiedRoleManagementPolicyExpirationRule) {
        return sendAsync(HttpMethod.PUT, newUnifiedRoleManagementPolicyExpirationRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyExpirationRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyExpirationRule the object to create/update
     * @return the created UnifiedRoleManagementPolicyExpirationRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyExpirationRule put(@Nonnull final UnifiedRoleManagementPolicyExpirationRule newUnifiedRoleManagementPolicyExpirationRule) throws ClientException {
        return send(HttpMethod.PUT, newUnifiedRoleManagementPolicyExpirationRule);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyExpirationRuleRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyExpirationRuleRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

