// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RoleEligibilityScheduleRequestFilterByCurrentUserOptions;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Eligibility Schedule Request Filter By Current User Collection Request Builder.
 */
public class UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<UnifiedRoleEligibilityScheduleRequest, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionResponse, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionPage, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of UnifiedRoleEligibilityScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder.class, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of UnifiedRoleEligibilityScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder.class, UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final UnifiedRoleEligibilityScheduleRequestFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
